CREATE TABLE IF NOT EXISTS Student (
    id INT PRIMARY KEY AUTO_INCREMENT,
    firstname VARCHAR(30) NOT NULL,
    lastname VARCHAR(30) NOT NULL
);

CREATE TABLE IF NOT EXISTS Organization (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(50) NOT NULL,
    idCategory INT
);

CREATE TABLE IF NOT EXISTS Category (
    id INT PRIMARY KEY AUTO_INCREMENT,
    label VARCHAR(20) NOT NULL
);

CREATE TABLE IF NOT EXISTS Internship (
    idStudent INT,
    idOrganization INT,
    PRIMARY KEY(idStudent,idOrganization)
);

ALTER TABLE Organization ADD FOREIGN KEY (idCategory) REFERENCES Category(id);

ALTER TABLE Internship ADD FOREIGN KEY (idStudent) REFERENCES Student(id);

ALTER TABLE Internship ADD FOREIGN KEY (idOrganization) REFERENCES Organization(id);
