<?php
require 'config.php';
try {
  $pdo = new PDO($db_dsn, $db_usr, $db_pwd);
  $stmt = $pdo->query("SELECT id, firstname, lastname FROM Student");
} catch (PDOException $e) {
  http_response_code(500);
  die($e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="fr"><head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <link rel="stylesheet" href="https://www.w3schools.com/w3css/5/w3.css"/>
  <title>Liste des étudiants</title>
</head>
<body>
  <h1 class="w3-center">Liste des étudiants</h1>
  <ul class="w3-ul w3-margin">
  <?php while ($student = $stmt->fetch(PDO::FETCH_OBJ)): ?>
    <li class="w3-padding-16"><?= htmlentities($student->firstname . ' ' . $student->lastname) ?></li>
  <?php endwhile; ?>
  </ul>
  <p><a class="w3-button w3-right w3-margin w3-grey" href="student-edit.php">Ajouter</a></p>
</body>
</html>
