# Procédure d'installation de Stage-Dating

## Prérequis

Cette application est conçue pour s'exécuter sur un serveur <abbr title="HyperText Transfer Protocol">HTTP</abbr>
avec PHP (version >= 7.0) et un <abbr title="Système de Gestion de Bases de Données">SGBD</abbr>
pris en charge par <abbr title="PHP Data Object">PDO</abbr> (MariaDB, PostgreSQL
ou Sqlite par exemple).

Elle a été testée :

- côté serveur : avec Apache et Caddy sous Debian 13 avec PHP 8.4, MariaDB 11.8 et SQLite 3.46.1.
- côté client : avec les navigateurs Firefox (desktop et mobile) et Chrome (mobile).

L'application utilise le cadriciel [W3.css](https://www.w3schools.com/w3css/)
ainsi que la police d'icônes [Fontello](https://fontello.com/), sans autre
bibliothèque additionnelle.

*Dans sa version actuelle, l'application ne gère qu'un événement à la fois.
Pour en gérer plusieurs simultanément, il faut la dupliquer.*


## Procédure d'installation

### Copie des fichiers

- Récupérer les fichiers de l'application depuis l'archive ou le dépôt Git.
- Déployer le contenu du dossier `src`.


### Paramétrage de l'application

Éditer le fichier `config.php` :

- paramétrer la base de données ;
- définir le mot de passe du gestionnaire (cf `$teacher_password`) ; pour
générer le condensé du mot de passe, utiliser (par exemple) [BCrypt](https://www.bcrypt.fr/) ;
- activer ou désactiver le mode auto-inscription (cf `$open_registration`) ;
- définir le nombre de sessions (nombre d'entretien par étudiant) ;
- activer ou désactiver le mode démonstration - avec de fausses données (cf `$demo_fake`) ;
- adapter les données d'identité de l'établissement (logo, proviseur, adresse).


### Base de données SQLite

Une base de données SQLite est préinstallée. Pour l'utiliser vérifier que
le processus du serveur web (`www-data` sous Debian) a les droits d'écriture
sur le dossier `db` et le fichier `db/sb.sqlite` ; cf commande `chmod -R 777 db`.
Un fichier `.htaccess` (Apache) empêche le téléchargement direct de la base de données.

### Base de données MariaDB

*Solution alternative à la base de données SQLite.*

Créer une base de données avec les requêtes SQL suivantes :

```sql
CREATE TABLE IF NOT EXISTS Student (
    id INT PRIMARY KEY AUTO_INCREMENT,
    firstname VARCHAR(30) NOT NULL,
    lastname VARCHAR(30) NOT NULL
);

CREATE TABLE IF NOT EXISTS Tutor (
    id INT PRIMARY KEY AUTO_INCREMENT,
    firstname VARCHAR(30) NOT NULL,
    lastname VARCHAR(30) NOT NULL
);

CREATE TABLE IF NOT EXISTS Vote (
    idStudent INT,
    idTutor INT,
    PRIMARY KEY(idStudent,idTutor)
);

CREATE TABLE IF NOT EXISTS Participation (
    idStudent INT,
    idTutor INT,
    idSession INT,
    PRIMARY KEY(idStudent,idTutor)
);

ALTER TABLE Vote ADD FOREIGN KEY (idStudent) REFERENCES Student(id);

ALTER TABLE Vote ADD FOREIGN KEY (idTutor) REFERENCES Tutor(id);

ALTER TABLE Participation ADD FOREIGN KEY (idStudent) REFERENCES Student(id);

ALTER TABLE Participation ADD FOREIGN KEY (idTutor) REFERENCES Tutor(id);
```

Pour d'autres SGBD, adapter les clauses pour les identifiants auto-incrémentés :

- en SQLite, remplacer `INT PRIMARY KEY AUTO_INCREMENT` par `INTEGER PRIMARY KEY AUTOINCREMENT` ;
- en PostgresQL, remplacer `INT PRIMARY KEY AUTO_INCREMENT` par `SERIAL PRIMARY KEY`.
