<?php
session_start();
require 'config.php';

if (!isset($_SESSION['instance']) || $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) != $_SESSION['instance']) { //not identified
	require 'inc/head.html';
?>
</head><body><div id="body">
	<header class="w3-center">
		<img class="w3-image w3-margin" alt="Logo de l'établissement" src="<?=$school_logo?>"/>
		<h1 class="w3-center w3-xxlarge">Stage-Dating v0.4</h1>
	</header>
	<main class="w3-flex"><div class="w3-half w3-padding">
	<?php if (isset($_GET['error'])) { ?>
		<p class="w3-red w3-padding w3-center w3-round"><?=htmlentities($_GET['error'])?></p>
	<?php } ?>
		<input class="w3-check w3-margin-bottom" id="toggle" type="checkbox"/><label for="toggle">&nbsp;Accès Gestionnaire</label>
		<form id="admin" action="action-login.php" method="POST" class="w3-center">
			<input id="password" type="password" name="password" placeholder="Mot de passe" required="required" class="w3-input w3-border w3-round w3-margin-bottom"/>
			<input type="hidden" name="firstname" value="Gestionnaire"/><input type="hidden" name="lastname" value=" "/>
			<div><input type="submit" value="Gérer l'évènement" class="w3-button w3-purple w3-round"/></div>
		</form>
		<form id="login" action="action-login.php" method="POST" class="w3-center">
			<input id="firstname" name="firstname" type="text" placeholder="Prénom" required="required" class="w3-input w3-border w3-round w3-margin-bottom"/>
			<input id="lastname" name="lastname" type="text" placeholder="Nom" required="required" class="w3-input w3-border w3-round w3-margin-bottom"/>
			<div class="w3-margin-bottom">
				<input class="w3-radio" type="radio" name="status" value="student" id="student" required="required"/><label for="student" class="w3-margin-right">&nbsp;Étudiant·e</label>
				<input class="w3-radio" type="radio" name="status" value="tutor" id="tutor" required="required"/><label for="tutor" class="w3-margin-right">&nbsp;Tuteur·rice</label>
			</div>
			<div><input type="submit" value="Participer" class="w3-button w3-green w3-round"/></div>
		</form>
	</div></main>
	<footer class="w3-center w3-padding"><a href="legal.php">Mentions légales</a></footer>
</div></body></html>
<?php
} else { //identified
	try {
		$pdo = new PDO($db_dsn, $db_user, $db_password);
	} catch (PDOException $e) {
		print($e->getMessage());
		die();
	}
	$phase = $pdo->query('SELECT idSession FROM Participation')->fetch(PDO::FETCH_OBJ) ? 'interview' : 'vote';
	require 'inc/' . $_SESSION['status'] . '-' . $phase . '.php'; //status ∈ ['student', 'tutor', 'teacher']
}
?>
