"use strict";

function saveScrollPosition() {
	document.cookie = "scrollPosition=" + window.scrollY + "; path=/";
}

function restoreScrollPosition() {
	const cookies = document.cookie.split('; ');
    let scrollPosition = 0;
    for (let cookie of cookies) {
        if (cookie.startsWith('scrollPosition=')) {
            scrollPosition = cookie.split('=')[1];
            break;
        }
    }
    if (scrollPosition) {
        window.scrollTo(0, parseInt(scrollPosition, 10));
    }
}

function guessStatusFromName(e) {
	const firstname = document.getElementById('firstname').value;
	const lastname = document.getElementById('lastname').value;
	if (lastname != '' && firstname != '') {
		fetch('ws-login-helper.php?firstname=' + firstname + '&lastname=' + lastname)
		.then(response => response.text())
		.then(data => {
			const status = new URLSearchParams(data).get('status');
			if (status == 'undefined') {
				document.getElementById('tutor').checked = false;
				document.getElementById('student').checked = false;
			} else {
				document.getElementById(status).checked = true;
			}
		});
	}
}

function addLoginEventListener() {
	if (document.getElementById('login')) {
		document.getElementById('firstname').addEventListener('input', guessStatusFromName);
		document.getElementById('lastname').addEventListener('input', guessStatusFromName);
	}
}

function addConfirmEventListener() {
	const confirmButtons = document.querySelectorAll('.confirm');
	confirmButtons.forEach(button => {
		button.addEventListener('click', event => {
			event.preventDefault();
			const form = button.parentNode;
			//_teacher-vote.php: const fullname = form.previousElementSibling.firstChild.nodeValue;
			const fullname = form.parentNode.firstChild.firstChild.nodeValue;
            if (confirm('Supprimer ' + fullname + ' ?')) { //ugly but simple
                form.submit();
            }
		});
	});
}

window.addEventListener('beforeunload', function() {
    saveScrollPosition();
});

window.addEventListener('load', function() {
    restoreScrollPosition();
    addConfirmEventListener();
    addLoginEventListener();
});
