<?php
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] != 'GET') {
	header($_SERVER['SERVER_PROTOCOL'] . ' 405 Method Not Allowed');
	die();
}
if (!isset($_GET['firstname']) || $_GET['firstname'] == '' || !isset($_GET['lastname']) || $_GET['lastname'] == '') {
	header($_SERVER['SERVER_PROTOCOL'] . ' 400 Bad Request');
	die();
}

//$firstname = ucfirst(strtolower(trim($_POST['firstname'])));
$firstparts = explode('-', $_GET['firstname']); //not POST !
for ($i=0; $i<count($firstparts); $i++) {
  $firstparts[$i] = ucfirst(trim(strtolower($firstparts[$i])));
}
$firstname = implode('-', $firstparts);
$lastname = strtoupper(trim($_GET['lastname']));

try {
	$pdo = new PDO($db_dsn, $db_user, $db_password);
} catch (PDOException $e) {
	print($e->getMessage());
	die();
}

$i = 0; $tables = ['Tutor', 'Student']; $status = NULL;
while ($status == NULL && $i < count($tables)) {
	$table = $tables[$i];
	$stmt = $pdo->prepare("SELECT id FROM $table WHERE firstname = :firstname AND lastname = :lastname");
	$stmt->bindParam(':firstname', $firstname, PDO::PARAM_STR);
	$stmt->bindParam(':lastname', $lastname, PDO::PARAM_STR);
	$stmt->execute();
	if ($stmt->fetch(PDO::FETCH_OBJ)) {
		$status = strtolower($table);
	}
	$i++;
}

echo 'status=' . ($status == NULL ? 'undefined' : $status);
?>
