<?php
namespace controller;
use teachframe\ORM;
use model\Archipelago;

class ArchipelagoController {
  function getAll() {
		$archipelagos = ORM::getAll(Archipelago::class);

    echo '<p>Liste des archipels :</p>';
    echo '<ul>'; //présentation minimaliste en attendant la vue
    foreach ($archipelagos as $archipelago) {
      echo '<li><a href="' . Router::getURL('/archipelago/' .$archipelago->getId()) . '">' . $archipelago->getName() . '</a></li>';
    }
    echo '</ul>';
  }

  function getOne (string $id) {
    $archipelago = ORM::getOne(Archipelago::class, $id);
    if (null == $archipelago) {
      http_response_code(404);
      die('error: \'/archipelago/' . $id . '\' not found');
    }

    echo '<p>Archipel : ' . $archipelago->getName() . '</p><p>Liste des îles :</p>'; //présentation minimaliste en attendant la vue
    echo '<ul>'; //présentation minimaliste en attendant la vue
    foreach ($archipelago->getIslands() as $island) {
      echo '<li><a href="' . Router::getURL('/island/' .$island->getId()) . '">' . $island->getName() . '</a></li>';
    }
    echo '</ul>';
    echo '<p><a href="' . Router::getURL('/archipelago/') . '">Liste des archipels.</a></p>';
  }
}
