<?php
namespace controller;
use teachframe\ORM;
use model\Island;

class IslandController {
  function getAll() {
		$islands = ORM::getAll(Island::class);

    echo '<p>Liste des îles :</p>';
    echo '<ul>'; //présentation minimaliste en attendant la vue
    foreach ($islands as $island) {
      echo '<li><a href="' . Router::getURL('/island/' .$island->getId()) . '">' . $island->getName() . '</a></li>';
    }
    echo '</ul>';
  }

  function getOne (string $id) {
    $island = ORM::getOne(Island::class, $id);
    if (null == $island) {
      http_response_code(404);
      die('error: \'/island/' . $id . '\' not found');
    }
    $archipelago = $island->getArchipelago();

    echo '<dl>'; //présentation minimaliste en attendant la vue
    echo '<dt>Île :</dt><dd>' . $island->getName() . '</dd>';
    echo '<dt>Archipel :</dt><dd><a href="' . Router::getURL('/archipelago/' . $archipelago->getId()) . '">' . $archipelago->getName() . '</a></dd>';
    echo '</dl>';
    echo '<p><a href="' . Router::getURL('/island/') . '">Liste des îles.</a></p>';
  }
}
