<?php
/**
 * TeachFrame - Cadriciel simple à finalité pédagogique pour l'enseignement du PHP.
 * Copyleft (c) 2024 Frank ENDRES (frank.endres@ac-polynesie.pf)
 * Ce programme est régi par la licence CeCILL 2.1 soumise au droit français et
 * respectant les principes de diffusion des logiciels libres.
 * http://www.cecill.info/licences/Licence_CeCILL_V2.1-fr.html
 */

namespace teachframe;
if (__FILE__ === $_SERVER['SCRIPT_FILENAME']) { header($_SERVER['SERVER_PROTOCOL'] . ' 403 Forbidden'); die(); }

use \ArrayAccess;
use \ArrayIterator;
use \Countable;
use \IteratorAggregate;

/**
 * Cette classe abstraite représente une collection d'éléments qui peut être manipulée
 * comme un tableau. Elle permet de compenser l'absence de type 'Array<NomClasse>' du PHP.
 * Elle doit être utilisée par les classes du modèle ayant une collection comme attribut.
 * Exemple :
 *    use teachframe\Collection;
 *    class NomClasseCollection extends Collection {}'
 *    class AutreClasse {
        NomClasseCollection $items;
      }
 * Le nom doit impérativement respecter la forme indiquée pour que l'ORM fonctionne.
 */
abstract class Collection implements ArrayAccess, Countable, IteratorAggregate {
  private array $items;
  /**
   * @param $items Tableau des éléments pour initialiser la collection (vide par défaut).
   */
  final public function __construct(array $items = []) {
    $this->items = $items;
  }
  final public function offsetExists(mixed $offset) : bool {
    return isset($this->items[$offset]);
  }
  final public function offsetGet(mixed $offset) : mixed {
    return $this->items[$offset];
  }
  final public function offsetSet(mixed $offset, mixed $value) : void {
    if ($offset === null) {
      $this->items[] = $value;
    } else {
      $this->items[$offset] = $value;
    }
  }
	final public function offsetUnset(mixed $offset) : void {
    unset($this->items[$offset]);
    $this->items = array_values($this->items);
  }
  final public function count() : int {
    return count($this->items);
  }
  final public function getIterator() : ArrayIterator {
    return new ArrayIterator($this->items);
  }
}
