<?php
namespace model;

class Archipelago {
	protected int $id;
	protected string $name;
	protected IslandCollection $islands;

	function __construct(int $id, string $name) {
		$this->id = $id;
		$this->name = $name;
		$this->islands = new IslandCollection();
	}

	public function getId(): int {
		return $this->id;
	}

	public function setId(int $id): int {
		$this->id = $id;
		return $this->id;
	}

	public function getName(): string {
		return $this->name;
	}

	public function setName(string $name): string {
		$this->name = $name;
		return $this->name;
	}

	public function getIslands(): IslandCollection {
		if (!isset($this->islands)) $this->islands = new IslandCollection();
		return $this->islands;
	}

	public function addIsland(Island $item): Archipelago {
		if (!isset($this->islands)) $this->islands = new IslandCollection();
		$this->islands[] = $item;
		return $this;
	}

	public function removeIsland(Island $item): Archipelago {
		if (!isset($this->islands)) $this->islands = new IslandCollection();
		$key = array_search($item, $this->islands);
		if ($key !== false) {
			unset($this->islands[$key]);
			$this->islands = array_values($this->islands);
		}
		return $this;
	}
}
