<?php
namespace controller;
use teachframe\ORM;
use teachframe\Cache;
use model\Archipelago;
use view\ArchipelagoView;

class ArchipelagoController {
  function getAll() {
    $html = Cache::get('/archipelagos');
    if (null == $html) {
      $archipelagos = ORM::getAll(Archipelago::class);
      $html = new ArchipelagoView()->renderAll($archipelagos);
      Cache::set('/archipelagos', $html);
    }
    echo $html;
  }

  function getOne (string $id) {
    $html = Cache::get('/archipelago/' . $id);
    if (null == $html) {
      $archipelago = ORM::getOne(Archipelago::class, $id);
      if (null == $archipelago) {
        http_response_code(404);
        die('error: \'/archipelago/' . $id . '\' not found');
      }
      $html = new ArchipelagoView()->renderOne($archipelago);
      Cache::set('/archipelago/' . $id, $html);
    }
    echo $html;
  }
}
