<?php
namespace controller;
use teachframe\ORM;
use teachframe\Cache;
use model\Island;
use view\IslandView;

class IslandController {
  function getAll() {
    $html = Cache::get('/islands');
    if (null == $html) {
      $islands = ORM::getAll(Island::class);
      $html = new IslandView()->renderAll($islands);
      Cache::set('/islands', $html);
    }
    echo $html;
  }

  function getOne (string $id) {
    $html = Cache::get('/island/' . $id);
    if (null == $html) {
      $island = ORM::getOne(Island::class, $id);
      if (null == $island) {
        http_response_code(404);
        die('error: \'/island/' . $id . '\' not found');
      }
      $html = new IslandView()->renderOne($island);
      Cache::set('/island/' . $id, $html);
    }
    echo $html;
  }
}
