<?php
namespace view;
use model\Archipelago;
use teachframe\Router;

class ArchipelagoView extends IndexView {
  function renderAll(array $archipelagos): string {
    ob_start(); ?>

    <ul class="w3-ul">
      <?php foreach ($archipelagos as $archipelago): ?>
      <li><a href="<?=Router::getURL('/archipelago/' . $archipelago->getId())?>"><?=htmlspecialchars($archipelago->getName())?></a></li>
      <?php endforeach; ?>
    </ul>

    <?php $content = ob_get_clean();
    return $this->render('/Archipels', '/archipelago', $content);
  }

  function renderOne(Archipelago $archipelago): string {
    ob_start(); ?>

    <div class="w3-margin-top w3-container">
      <div class="w3-card w3-padding">
        <p>Archipel&nbsp;: <?=htmlspecialchars($archipelago->getName())?></p>
        <h4 class="w3-large">Liste des îles :</h4>
        <ul class="w3-ul">
        <?php foreach ($archipelago->getIslands() as $island): ?>
          <li><a href="<?=Router::getURL('/island/' . $island->getId())?>"><?=htmlspecialchars($island->getName())?></a></li>
        <?php endforeach; ?>
        </ul>
      </div>
    </div>

    <?php $content = ob_get_clean();
    return $this->render('/Archipels/' . $archipelago->getName(), '/archipelago/' . $archipelago->getId(), $content);
  }
}
