<?php
namespace view;
use model\Island;
use teachframe\Router;

class IslandView extends IndexView {
  public function renderAll(array $islands): string {
    ob_start(); ?>

    <ul class="w3-ul">
    <?php foreach ($islands as $island): ?>
      <li><a href="<?=Router::getURL('/island/' . $island->getId())?>"><?=htmlspecialchars($island->getName())?></a></li>
    <?php endforeach; ?>
    </ul>

    <?php $content = ob_get_clean();
    return $this->render('/Îles', '/island', $content);
  }

  public function renderOne(Island $island): string {
    $archipelago = $island->getArchipelago();
    ob_start(); ?>

    <div class="w3-margin-top w3-container">
      <dl class="w3-card w3-padding w3-grid">
        <dt>Île :</dt><dd><?=htmlspecialchars($island->getName())?></dd>
        <dt>Population :</dt><dd><?=$island->getPopulation()?> habitants</dd>
        <dt>Surface :</dt><dd><?=$island->getArea()?> km²</dd>
        <dt>Archipel :</dt><dd><a href="<?=Router::getURL('/archipelago/' . $archipelago->getId())?>"><?=htmlspecialchars($archipelago->getName())?></a></dd>
      </dl>
    </div>

    <?php $content = ob_get_clean();
    return $this->render('/Îles/' . $island->getName(), '/island/' . $island->getId(), $content);
  }
}
