<?php
define('SEARCH_PATHS', ['lib', '../lib']);

if (__FILE__ === $_SERVER['SCRIPT_FILENAME']) { header('HTTP/1.0 403 Forbidden'); die(); }

spl_autoload_register(function ($className) {
  $className = str_replace('\\', DIRECTORY_SEPARATOR, $className);
  $path = $className . '.php';
  $i = 0;
  while ($i < count(SEARCH_PATHS) && !file_exists($path)) {
    $path = SEARCH_PATHS[$i] . '/' . $className . '.php';
    $i++;
	}
	if (! file_exists($path)) {
		http_response_code(500);
		die('error: class file for \'' . $className . '\' is missing');
	}
  require $path;
});
