<?php
namespace view;
use teachframe\Router;

class IndexView {
  public function render(string $title, string $uri, string $content): string {
    $uriParts = explode('/', $uri);
    $titleParts = explode('/', $title);
    ob_start(); ?>

<!DOCTYPE html>
<html lang="fr"><head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <link rel="stylesheet" href="<?=Router::getURL('/lib/static/w3.css')?>">
  <link rel="stylesheet" href="<?=Router::getURL('/lib/static/fontello.css')?>">
  <link rel="icon" type="image/png" href="<?=Router::getURL('/lib/static/favicon.png')?>"/>
  <link rel="stylesheet" href="<?=Router::getURL('/view/static/styles.css')?>">
  <title><?=htmlspecialchars($title)?></title>
</head><body>
  <header class="w3-indigo w3-container"><ul class="w3-ul w3-large w3-bar">
    <li class="w3-bar-item"><a href="<?=Router::getURL("/")?>"><span title="Accueil" class="icon-home-1"><i>&nbsp;¤&nbsp;</i></span></a></li>
    <?php for ($i = 1; $i < count($titleParts); $i++): ?>
    <li class="w3-bar-item icon-right-open"><i>&nbsp;&gt;&nbsp;</i></li>
      <?php if (isset($uriParts[$i])): ?>
      <?php $uriPart = Router::getURL(implode('/', array_slice($uriParts, 0, $i+1))); ?>
    <li class="w3-bar-item"><a href="<?=$uriPart?>"><?=htmlspecialchars($titleParts[$i])?></a></li>
      <?php else: ?>
    <li class="w3-bar-item"><?=htmlspecialchars($titleParts[$i])?></li>
      <?php endif; ?>
    <?php endfor; ?>
  </ul></header>
  <main class="w3-margin-top">
    <?=$content?>
  </main>
</body></html>

  <?php return ob_get_clean();
  }

  public function index() {
    ob_start(); ?>

    <h1 class="w3-center w3-xlarge">PolyApp</h1>
    <div class="w3-container w3-margin-top"><ul class="w3-ul w3-card">
      <li><a href="<?=Router::getURL("/island")?>">Îles</a></li>
      <li><a href="<?=Router::getURL("/archipelago")?>">Archipels</a></li>
    </ul></div>

    <?php $content = ob_get_clean();
    echo $this->render('PolyApp', '', $content);
  }
}
