<?php
namespace api;
use teachframe\ORM;
use teachframe\IO;
use teachframe\Cache;
use model\Archipelago;

class ArchipelagoController {
  function all() {
    $archipelagos = ORM::getAll(Archipelago::class);
    IO::send($archipelagos);
  }

  function retrieve (string $id) {
    $archipelago = ORM::getOne(Archipelago::class, $id);
    if (null == $archipelago) {
      http_response_code(404);
      die('error: \'/archipelago/' . $id . '\' not found');
    }
    IO::send($archipelago);
  }

  private function resetCache(Archipelago $archipelago) {
    Cache::reset('/archipelagos');
    Cache::reset('/archipelago/' . $archipelago->getId());
    foreach ($archipelago->getIslands() as $island) Cache::reset('/island/' . $island->getId());
  }

  function create(string $id) {
    if (0 != $id) {
      http_response_code(400);
      die('error: id should be 0 when creating archipelago');
    }
    $archipelago = new Archipelago(0, '');
    $input = IO::getInputs();
    IO::validateInputs(['name:*s'], $input);
    $archipelago->setName($input->name);
    ORM::insert($archipelago);
    $this->resetCache($archipelago);
    IO::send([ 'id' => $archipelago->getId() ]);
  }

  function update(string $id) {
    $archipelago = ORM::getOne(Archipelago::class, $id);
    if (null == $archipelago) {
      http_response_code(404);
      die('error: \'/archipelago/' . $id . '\' not found');
    }
    $input = IO::getInputs();
    IO::validateInputs(['name:*s'], $input);
    $archipelago->setName($input->name);
    ORM::update($archipelago);
    $this->resetCache($archipelago);
  }

  function delete(string $id) {
    $archipelago = ORM::getOne(Archipelago::class, $id);
    if (null == $archipelago) {
      http_response_code(404);
      die('error: \'/archipelago/' . $id . '\' not found');
    }
    ORM::delete($archipelago);
    $this->resetCache($archipelago);
  }
}
