<?php
namespace api;
use teachframe\ORM;
use teachframe\IO;
use teachframe\Cache;
use model\Island;
use model\Archipelago;

class IslandController {
  function all() {
    $islands = ORM::getAll(Island::class);
    IO::send($islands);
  }

  function retrieve (string $id) {
    $island = ORM::getOne(Island::class, $id);
    if (null == $island) {
      http_response_code(404);
      die('error: \'/island/' . $id . '\' not found');
    }
    IO::send($island);
  }

  private function commonCreateUpdate(Island $island):void {
    $input = IO::getInputs();
    IO::validateInputs(['name:*s', 'population:*i', 'area:*i', 'idArchipelago:*i'], $input);
    $archipelago = ORM::getOne(Archipelago::class, $input->idArchipelago, false);
    if (null == $archipelago) {
      http_response_code(400);
      die('error: integrity constraint failed (idArchipelago = ' . $input->idArchipelago . ')');
    }
    $island->setName($input->name);
    $island->setPopulation($input->population);
    $island->setArea($input->area);
    $island->setArchipelago($archipelago);
  }

  private function resetCache(Island $island) {
    Cache::reset('/islands');
    Cache::reset('/island/' . $island->getId());
    Cache::reset('/archipelago/' . $island->getArchipelago()->getId());
  }

  function create(string $id) {
    if (0 != $id) {
      http_response_code(400);
      die('error: id should be 0 when creating island');
    }
    $island = new Island(0, '', -1, -1, new Archipelago(0, ''));
    $this->commonCreateUpdate($island);
    ORM::insert($island);
    $this->resetCache($island);
    IO::send([ 'id' => $island->getId() ]);
  }

  function update(string $id) {
   $island = ORM::getOne(Island::class, $id);
    if (null == $island) {
      http_response_code(404);
      die('error: \'/island/' . $id . '\' not found');
    }
    $this->commonCreateUpdate($island);
    ORM::update($island);
    $this->resetCache($island);
  }

  function delete(string $id) {
    $island = ORM::getOne(Island::class, $id);
    if (null == $island) {
      http_response_code(404);
      die('error: \'/island/' . $id . '\' not found');
    }
    ORM::delete($island);
    $this->resetCache($island);
  }
}
