<?php
namespace view;
use model\Island;
use teachframe\ORM;
use teachframe\Router;

class IslandView extends IndexView {
  public function renderAll(array $islands): string {
    ob_start(); ?>

    <ul class="w3-ul">
    <?php foreach ($islands as $island): ?>
      <li><a href="<?=Router::getURL('/island/' . $island->getId())?>"><?=htmlspecialchars($island->getName())?></a></li>
    <?php endforeach; ?>
    </ul>
    <p class="w3-container"><a class="w3-button w3-right w3-indigo" href="<?=Router::getURL('/island/0/edit')?>">Ajouter une île</a></p>

    <?php $content = ob_get_clean();
    return $this->render('/Îles', '/island', $content);
  }

  public function renderOne(Island $island): string {
    $archipelago = $island->getArchipelago();
    ob_start(); ?>

    <div class="w3-margin-top w3-container">
      <dl class="w3-card w3-padding w3-grid">
        <dt>Île :</dt><dd><?=htmlspecialchars($island->getName())?></dd>
        <dt>Population :</dt><dd><?=$island->getPopulation()?> habitants</dd>
        <dt>Surface :</dt><dd><?=$island->getArea()?> km²</dd>
        <dt>Archipel :</dt><dd><a href="<?=Router::getURL('/archipelago/' . $archipelago->getId())?>"><?=htmlspecialchars($archipelago->getName())?></a></dd>
      </dl>
      <form id="delete" method="POST" action="<?=Router::getURL('/island/' . $island->getId())?>"></form>
      <p class="w3-bar">
        <a class="w3-bar-item w3-button w3-indigo w3-right" href="<?=Router::getURL('/island/' . $island->getId() . '/edit')?>">&nbsp;Éditer&nbsp;</a>
        <button form="delete" class="w3-bar-item w3-button w3-red">Effacer</button>
      </p>
    </div>

    <?php $content = ob_get_clean();
    return $this->render('/Îles/' . $island->getName(), '/island/' . $island->getId(), $content);
  }

  public function renderEdit(Island $island, array $archipelagos): string {
    ob_start(); ?>

    <div class="w3-margin-top w3-container">
      <form method="POST" action="<?=Router::getURL('/island/' . $island->getId())?>" class="w3-card w3-padding">
        <p>
          <label class="w3-bold" for="name">Île :</label>
          <input required="required" id="name" name="name" type="text"
                 value="<?=htmlspecialchars($island->getName())?>" class="w3-input w3-border"/>
        </p>
        <p>
          <?php $population = -1 == $island->getPopulation() ? '' : $island->getPopulation(); ?>
          <label class="w3-bold" for="population">Population :</label>
          <input required="required" type="number" id="population" name="population"
                 value="<?=$population?>" class="w3-input w3-border"/>
        </p>
        <p>
          <?php $area = -1 == $island->getArea() ? '' : $island->getArea(); ?>
          <label class="w3-bold" for="area">Surface :</label>
          <input required="required" type="number" id="area" name="area"
                 value="<?=$area?>" class="w3-input w3-border"/>
        </p>
        <p>
          <label class="w3-bold" for="idArchipelago">Archipel :</label>
          <select class="w3-select" id="idArchipelago" name="idArchipelago">
            <?php foreach ($archipelagos as $archipelago): ?>
            <?php $selected = $archipelago->getId() == $island->getArchipelago()->getId() ? 'selected="selected"' : '';?>
            <option <?=$selected?> value="<?=$archipelago->getId()?>"><?=htmlspecialchars($archipelago->getName())?></option>
            <?php endforeach; ?>
          </select>
        </p>
        <p class="w3-bar"><button class="w3-bar-item w3-right w3-button w3-green">Enregistrer</button></p>
      </form>
    </div>

    <?php $content = ob_get_clean();
    $name = '' == $island->getName() ? 'Nouvelle' : $island->getName();
    $path = 0 == $island->getId() ? '/island' : '/island/' . $island->getId();
    return $this->render('/Îles/' . $name, $path, $content);
  }
}
