<?php
namespace controller;
use teachframe\ORM;
use teachframe\Cache;
use teachframe\IO;
use teachframe\Router;
use model\Archipelago;
use view\ArchipelagoView;

class ArchipelagoController {
  function getAll() {
    if (IO::htmlMode()) {
         $html = Cache::get('/archipelagos.html');
        if (null == $html) {
          $archipelagos = ORM::getAll(Archipelago::class);
          $html = new ArchipelagoView()->renderAll($archipelagos);
          Cache::set('/archipelagos.html', $html);
        }
        echo $html;
    } else {
      $archipelagos = ORM::getAll(Archipelago::class);
      IO::send($archipelagos);
    }
  }

  function getOne (string $id) {
    if (IO::htmlMode()) {
      $html = Cache::get('/archipelago/' . $id . '.html');
      if (null == $html) {
        $archipelago = $this->initArchipelago($id);
        $html = new ArchipelagoView()->renderOne($archipelago);
        Cache::set('/archipelago/' . $id . '.html', $html);
      }
      echo $html;
    } else {
      $archipelago = $this->initArchipelago($id);
      IO::send($archipelago);
    }
  }

  function initArchipelago(int $id) {
    if (0 == $id) {
      $archipelago = new Archipelago(0, '');
    } else {
      $archipelago = ORM::getOne(Archipelago::class, $id);
      if (null == $archipelago) {
        http_response_code(404);
        die('error: \'/archipelago/' . $id . '\' not found');
      }
    }
    return $archipelago;
  }

  function edit (string $id) {
    $archipelago = $this->initArchipelago(intval($id));
    $html = new ArchipelagoView()->renderEdit($archipelago);
    echo $html;
  }

  function save(string $id) {
    $archipelago = $this->initArchipelago(intval($id));
    if (IO::hasInput()) {
      $input = IO::getInput();
      IO::validateInput(['name:*s'], $input);
      $archipelago->setName($input->name);
      ORM::persist($archipelago);
    } else if (0 != $id) { //sans données, c'est une suppression
      if (0 != count($archipelago->getIslands())) {
        http_response_code(403);
        die('error: \'/archipelago/' . $id . '\' still has islands');
      }
      ORM::delete($archipelago);
    } else {
      http_response_code(400);
      die('error: cannot delete \'/archipelago/0\'');
    }
    //Cache::resetAll();
    Cache::reset('/archipelagos.html');
    Cache::reset('/archipelago/' . $archipelago->getId() . '.html');
    foreach ($archipelago->getIslands() as $island) Cache::reset('/island/' . $island->getId());
    header('Location: ' . Router::getURL('/archipelago'));
    if (IO::htmlMode()) {
      header('Location: ' . Router::getURL('/archipelago'));
    } else if ($id == 0) {
      IO::send([ "id" => $archipelago->getId() ]);
    }
  }
}
