<?php
namespace view;
use model\Archipelago;
use teachframe\Router;

class ArchipelagoView extends IndexView {
  function renderAll(array $archipelagos): string {
    ob_start(); ?>

    <ul class="w3-ul">
      <?php foreach ($archipelagos as $archipelago): ?>
      <li><a href="<?=Router::getURL('/archipelago/' . $archipelago->getId())?>"><?=htmlspecialchars($archipelago->getName())?></a></li>
      <?php endforeach; ?>
    </ul>
    <p class="w3-container"><a class="w3-button w3-right w3-indigo" href="<?=Router::getURL('/archipelago/0/edit')?>">Ajouter un archipel</a></p>

    <?php $content = ob_get_clean();
    return $this->render('/Archipels', '/archipelago', $content);
  }

  function renderOne(Archipelago $archipelago): string {
    ob_start(); ?>

    <div class="w3-margin-top w3-container">
      <div class="w3-card w3-padding">
        <p>Archipel&nbsp;: <?=htmlspecialchars($archipelago->getName())?></p>
        <h4 class="w3-large">Liste des îles :</h4>
        <ul class="w3-ul">
        <?php foreach ($archipelago->getIslands() as $island): ?>
          <li><a href="<?=Router::getURL('/island/' . $island->getId())?>"><?=htmlspecialchars($island->getName())?></a></li>
        <?php endforeach; ?>
        </ul>
        <p class="w3-container"><a class="w3-button w3-right w3-indigo" href="<?=Router::getURL('/island/0/edit')?>">Ajouter une île</a></p>
      </div>
      <form id="delete" method="POST" action="<?=Router::getURL('/archipelago/' . $archipelago->getId())?>"></form>
      <p class="w3-bar">
        <a class="w3-bar-item w3-button w3-indigo w3-right" href="<?=Router::getURL('/archipelago/' . $archipelago->getId() . '/edit')?>">&nbsp;Éditer&nbsp;</a>
        <?php if (count($archipelago->getIslands()) == 0): ?>
        <button form="delete" class="w3-bar-item w3-button w3-red">Effacer</button>
        <?php endif; ?>
      </p>
    </div>

    <?php $content = ob_get_clean();
    return $this->render('/Archipels/' . $archipelago->getName(), '/archipelago/' . $archipelago->getId(), $content);
  }

  public function renderEdit(Archipelago $archipelago): string {
    ob_start();
    ?>

    <div class="w3-margin-top w3-container">
      <form method="POST" action="<?=Router::getURL('/archipelago/' . $archipelago->getId())?>" class="w3-card w3-padding" enctype="multipart/form-data">
        <p>
          <label class="w3-bold" for="name">Archipel :</label>
          <input required="required" id="name" name="name" type="text"
                 value="<?=htmlspecialchars($archipelago->getName())?>" class="w3-input w3-border"/>
        </p>
        <p class="w3-bar"><button class="w3-bar-item w3-right w3-button w3-green">Enregistrer</button></p>
      </form>
    </div>

    <?php $content = ob_get_clean();
    $name = '' == $archipelago->getName() ? 'Nouveau' : $archipelago->getName();
    $path = 0 == $archipelago->getId() ? '/archipelago' : '/archipelago/' . $archipelago->getId();
    return $this->render('/Archipels/' . $name,  $path, $content);
  }
}
